% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/422.p-Confidence_p-Bias_CC_All_Graph.R
\name{PlotpCOpBICAll}
\alias{PlotpCOpBICAll}
\title{Plots  p-confidence and p-bias for a given n and alpha level for 5 continuity corrected methods (Wald, Wald-T,  Score, Logit-Wald, ArcSine)}
\usage{
PlotpCOpBICAll(n, alp, c)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{c}{- Continuity correction}
}
\description{
Plots  p-confidence and p-bias for a given n and alpha level for 5 continuity corrected methods (Wald, Wald-T,  Score, Logit-Wald, ArcSine)
}
\details{
Plots of p-Confidence and p-Bias estimation of 5 continuity corrected methods (Wald, Wald-T,  Score, Logit-Wald, ArcSine)
}
\examples{
\dontrun{
n=5; alp=0.05;c=1/(2*n)
PlotpCOpBICAll(n,alp,c)
}
}
\seealso{
Other p-confidence and p-bias of continuity corrected methods: \code{\link{PlotpCOpBICAS}},
  \code{\link{PlotpCOpBICLT}}, \code{\link{PlotpCOpBICSC}},
  \code{\link{PlotpCOpBICTW}}, \code{\link{PlotpCOpBICWD}},
  \code{\link{pCOpBICAS}}, \code{\link{pCOpBICAll}},
  \code{\link{pCOpBICLT}}, \code{\link{pCOpBICSC}},
  \code{\link{pCOpBICTW}}, \code{\link{pCOpBICWD}}
}

