% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/401.p-Confidence_p-Bias_BASE_All.R
\name{pCOpBIBA}
\alias{pCOpBIBA}
\title{p-confidence and p-bias for  Bayesian method given n and alpha level and priors a & b}
\usage{
pCOpBIBA(n, alp, a1, a2)
}
\arguments{
\item{n}{- Number of trials}

\item{alp}{- Alpha value (significance level required)}

\item{a1}{- Shape parameter 1 for prior Beta distribution in Bayesian model}

\item{a2}{- Shape parameter 2 for prior Beta distribution in Bayesian model}
}
\value{
A dataframe with
 \item{x1}{  Number of successes (positive samples)}
 \item{pconfQ }{   p-Confidence Quantile}
 \item{pbiasQ }{   p-Bias Quantile}
 \item{pconfH }{   p-Confidence HPD}
 \item{pbiasH }{   p-Bias HPD}
}
\description{
p-confidence and p-bias for  Bayesian method given n and alpha level and priors a & b
}
\details{
Evaluation of Bayesian Highest Probability Density (HPD) and two tailed
intervals using p-confidence and p-bias for the \eqn{n + 1} intervals for the
Beta - Binomial conjugate prior model for the probability of success \code{p}
}
\examples{
n=5; alp=0.05;a1=1;a2=1
pCOpBIBA(n,alp,a1,a2)
}
\references{
[1] 2005 Vos PW and Hudson S.
Evaluation Criteria for Discrete Confidence Intervals: Beyond Coverage and Length.
The American Statistician: 59; 137 - 142.
}
\seealso{
Other p-confidence and p-bias of base methods: \code{\link{PlotpCOpBIAS}},
  \code{\link{PlotpCOpBIAll}}, \code{\link{PlotpCOpBIBA}},
  \code{\link{PlotpCOpBIEX}}, \code{\link{PlotpCOpBILR}},
  \code{\link{PlotpCOpBILT}}, \code{\link{PlotpCOpBISC}},
  \code{\link{PlotpCOpBITW}}, \code{\link{PlotpCOpBIWD}},
  \code{\link{pCOpBIAS}}, \code{\link{pCOpBIAll}},
  \code{\link{pCOpBIEX}}, \code{\link{pCOpBILR}},
  \code{\link{pCOpBILT}}, \code{\link{pCOpBISC}},
  \code{\link{pCOpBITW}}, \code{\link{pCOpBIWD}}
}

