% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R, R/methods.R
\docType{methods}
\name{propr}
\alias{[,propr,ANY,ANY-method}
\alias{[,propr-method}
\alias{dendrogram}
\alias{image,propr-method}
\alias{plot,propr,missing-method}
\alias{propr}
\alias{show,propr-method}
\alias{subset,propr-method}
\title{The propr Package}
\usage{
\S4method{show}{propr}(object)

\S4method{subset}{propr}(x, subset, select)

\S4method{[}{propr,ANY,ANY}(x, i = "all", j)

\S4method{plot}{propr,missing}(x, y, title = "Pairwise Proportionality")

\S4method{image}{propr}(x, cexRow = 10, cexCol = 10,
  title = "*LR Transformed Image")

dendrogram(object, title = "Proportional Clusters", group)
}
\arguments{
\item{object, x}{An object of class \code{propr}.}

\item{subset}{Subsets via \code{object@counts[subset, ]}.
Use this argument to rearrange subject order.}

\item{select}{Subsets via \code{object@counts[, select]}.
Use this argument to rearrange feature order.}

\item{i}{Operation used for the subset indexing. Select from
"==", "=", ">", ">=", "<", "<=", "!=", or "all".}

\item{j}{Reference used for the subset indexing. Provide a numeric
value to which to compare the proportionality metrics.}

\item{y}{Missing. Ignore. Leftover from the generic method definition.}

\item{title}{A character string. A title for the \code{propr} plot.}

\item{cexRow}{Numeric. Size of x-axis label.}

\item{cexCol}{Numeric. Size of y-axis label.}

\item{group}{A character or numeric vector. Supply feature groups for coloring.
Feature groups expected in the order they appear in \code{@counts}.}
}
\description{
Welcome to the \code{propr} package!

To learn more about how to calculate metrics of proportionality,
 see the help file for the functions \code{\link{phit}}
 and \code{\link{perb}}.

To learn more about the resultant \code{propr} class object, see
 the help file for the class definition \code{\link{propr-class}}.

To learn more about compositional data analysis, and its relevance
 to biological count data, see the bundled vignette.

To learn more about \code{propr} class methods, see below.
}
\section{Methods (by generic)}{

\code{show:} Method to show \code{propr} object.


\code{subset:} Method to subset \code{propr} object.


\code{[:} Method to subset \code{propr} object.


\code{plot:} Method to plot \code{propr} object.


\code{image:} Method to plot \code{propr} object.


\code{plot:} Method to plot \code{propr} object.
}

