% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spliceCorrection.R
\name{spliceCorrection}
\alias{spliceCorrection}
\title{Splice correction of a spectral matrix acquired with an ASD spectrometer}
\usage{
spliceCorrection(X, wav, splice = c(1000, 1830), interpol.bands = 10)
}
\arguments{
\item{X}{a numeric matrix or vector to transform (optionally a data frame that can
be coerced to a numerical matrix).}

\item{wav}{a numeric vector with band positions.}

\item{splice}{a numeric vector of the two positions of the splices,
default: \code{c(1000, 1830)}.
corresponding to the splices of the ASD FieldSpec Pro spectrometer.}

\item{interpol.bands}{the number of interpolation bands.}
}
\value{
a matrix with the splice corrected data.
}
\description{
Corrects steps in an input spectral matrix by linear interpolation of the
values of the edges of the middle sensor
}
\details{
Spectra acquired with an ASD FieldSpec Pro spectroradiometer usually exhibit
steps at the splice of the three built-in sensors,
positioned at 1000 nm (end of VNIR detector) and 1830 nm (end of SWIR1 detector).
}
\author{
Antoine Stevens
}
