% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_contaminants.R
\name{qc_contaminants}
\alias{qc_contaminants}
\title{Percentage of contaminants per sample}
\usage{
qc_contaminants(
  data,
  sample,
  protein,
  is_contaminant,
  intensity,
  n_contaminants = 5,
  plot = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame containing at least the input variables.}

\item{sample}{the name of the column containing the sample names.}

\item{protein}{the name of the column containing protein IDs or protein names.}

\item{is_contaminant}{the name of the column containing a logical indicating if the protein is a contaminant.}

\item{intensity}{the name of the column containing the corresponding raw or untransformed normalised intensity values.}

\item{n_contaminants}{numeric, indicating how many contaminants should be displayed individually. The rest is combined to a group called "other". The
default is 5.}

\item{plot}{logical, if TRUE a plot is returned. If FALSE a table is returned.}

\item{interactive}{logical, if TRUE the plot is interactive using plotly.}
}
\value{
A bar plot that displays the percentage of contaminating proteins over all samples. If \code{plot = FALSE} a data frame is returned.
}
\description{
Calculates the percentage of contaminating proteins as the share of total intensity
}
\examples{
\dontrun{
qc_contaminants(
  data,
  sample = sample,
  protein = leading_razor_protein,
  is_contaminant = potential_contaminant,
  intensity = intensity
)
}
}
