% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/provSummarizeR.R
\name{prov.summarize}
\alias{prov.summarize}
\alias{prov.summarize.file}
\alias{prov.summarize.run}
\title{Provenance summarization functions}
\usage{
prov.summarize(save = FALSE, create.zip = FALSE)

prov.summarize.file(prov.file, save = FALSE, create.zip = FALSE)

prov.summarize.run(r.script, save = FALSE, create.zip = FALSE, ...)
}
\arguments{
\item{save}{if true saves the summary to the file prov-summary.txt in the 
provenance directory}

\item{create.zip}{if true all of the provenance data will be packaged up
into a zip file stored in the current working directory.}

\item{prov.file}{the path to the file containing provenance}

\item{r.script}{the name of a file containing an R script}

\item{...}{extra parameters are passed to the provenance collector.  See rdt's prov.run function
or rdtLites's prov.run function for details.}
}
\description{
prov.summarize uses the provenance from the last execution of prov.run and outputs
a text summary to the R console

prov.summarize.file reads a JSON file that contains provenance and outputs
a text summary to the R console

prov.summarize.run executes a script, collects provenance, and outputs a
text summary to the console.
}
\details{
These functions use provenance collected using the rdtLite or rdt packages.

For provenance collected from executing a script file, the summary identifies:
\itemize{
  \item The name of the script file executed
  \item Environmental information identifying when the script was executed, the version of R,
     the computing system, the tool and version used to collect the provenance, the 
     location of the provenance file, and the hash algorithm used to hash data files.
  \item A list of libraries loaded and their versions
  \item The names of any scripts sourced
  \item The names of files input or output, the file timestamp, and its hashvalue
  \item Any URLs loaded and the time loaded
  \item Any errors or warnings along with the line on which they occurred, if known.
  \item Any messages sent to standard output along with the line on which they occurred, if known.
}

For provenance collected from a console session, only the environment and library information
appears in the summary.

Creating a zip file depends on a zip executable being on the search path.
By default, it looks for a program named zip.  To use a program with 
a different name, set the value of the R_ZIPCMD environment variable.  This
code has been tested with Unix zip and with 7-zip on Windows.
}
\examples{
\dontrun{prov.summarize ()}
testdata <- system.file("testdata", "prov.json", package = "provSummarizeR")
prov.summarize.file (testdata)
\dontrun{
testdata <- system.file("testscripts", "console.R", package = "provSummarizeR")
prov.summarize.run (testdata)}
}
