/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.ui.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class ExtendedGridLayout
implements LayoutManager {
    private int rows;
    private int columns;
    private int inset;
    private Component[][] components;

    public ExtendedGridLayout(int n, int n2, int n3) {
        this.rows = n;
        this.columns = n2;
        this.inset = n3;
        this.components = new Component[n2][n];
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    private void fillGrid(Container container) {
        int n = 0;
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.columns; ++j) {
                if (n >= container.getComponentCount()) continue;
                this.components[j][i] = container.getComponent(n);
                ++n;
            }
        }
    }

    @Override
    public void layoutContainer(Container container) {
        JComponent jComponent;
        Border border;
        Dimension dimension = container.getPreferredSize();
        Dimension dimension2 = container.getSize();
        Insets insets = new Insets(0, 0, 0, 0);
        if (container instanceof JComponent && (border = (jComponent = (JComponent)container).getBorder()) != null) {
            insets = border.getBorderInsets(container);
        }
        dimension2.width -= insets.left + insets.right;
        dimension2.height -= insets.bottom + insets.top;
        dimension.width -= insets.left + insets.right;
        dimension.height -= insets.bottom + insets.top;
        int n = insets.top;
        int n2 = dimension2.height - dimension.height;
        int n3 = n2 / this.rows;
        int n4 = dimension2.width - dimension.width;
        int n5 = n4 / this.columns;
        for (int i = 0; i < this.rows; ++i) {
            int n6 = insets.left;
            int n7 = this.getPreferredRowHeight(i);
            int n8 = n7 + n3;
            if (i == this.rows - 1) {
                n8 = dimension2.height - n + insets.top;
            }
            for (int j = 0; j < this.columns; ++j) {
                Component component;
                int n9 = this.getPreferredColumnWidth(j);
                int n10 = n9 + n5;
                if (j == this.columns - 1) {
                    n10 = dimension2.width - n6 + insets.left;
                }
                if ((component = this.components[j][i]) != null) {
                    component.setLocation(n6, n);
                    component.setSize(n10, n8);
                }
                n6 += n10 + this.inset;
            }
            n += n8 + this.inset;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        JComponent jComponent;
        Border border;
        int n;
        this.fillGrid(container);
        Dimension dimension = new Dimension();
        for (n = 0; n < this.columns; ++n) {
            dimension.width += this.getPreferredColumnWidth(n);
        }
        for (n = 0; n < this.rows; ++n) {
            dimension.height += this.getPreferredRowHeight(n);
        }
        Insets insets = new Insets(0, 0, 0, 0);
        if (container instanceof JComponent && (border = (jComponent = (JComponent)container).getBorder()) != null) {
            insets = border.getBorderInsets(container);
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        if (this.columns > 1 && this.inset > 0) {
            dimension.width += (this.columns - 1) * this.inset;
        }
        if (this.rows > 1 && this.inset > 0) {
            dimension.height += (this.rows - 1) * this.inset;
        }
        return dimension;
    }

    private int getPreferredRowHeight(int n) {
        int n2 = 0;
        for (int i = 0; i < this.columns; ++i) {
            Component component = this.components[i][n];
            if (component == null) continue;
            n2 = Math.max(n2, component.getPreferredSize().height);
        }
        return n2;
    }

    private int getPreferredColumnWidth(int n) {
        int n2 = 0;
        for (int i = 0; i < this.rows; ++i) {
            Component component = this.components[n][i];
            if (component == null) continue;
            n2 = Math.max(n2, component.getPreferredSize().width);
        }
        return n2;
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }
}

