% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/provenance.R
\name{get.n}
\alias{get.n}
\title{Calculate the number of grains required to achieve a desired level of sampling resolution}
\usage{
get.n(p = 0.05, f = 0.05)
}
\arguments{
\item{p}{the probability that all n grains in the sample have missed
at least one fraction of size f}

\item{f}{the size of the smallest resolvable fraction (0<f<1)}

\item{n,}{the number of grains in the sample}
}
\description{
Returns the number of grains that need to be analysed to decrease
the likelihood of missing any fraction greater than a given size
below a given level.
}
\examples{
# number of grains required to be 99\% that no fraction greater than 5\% was missed:
print(get.n(0.01))
# number of grains required to be 90\% that no fraction greater than 10\% was missed:
print(get.n(p=0.1,f=0.1))
}
\references{
Vermeesch, Pieter. "How many grains are needed for a
provenance study?." Earth and Planetary Science Letters 224.3
(2004): 441-451.
}

