% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/provenance.R
\name{ternary}
\alias{ternary}
\title{Define a ternary composition}
\usage{
ternary(X, x = NULL, y = NULL, z = NULL)
}
\arguments{
\item{X}{an object of class \code{compositional}}

\item{x}{string or a vector of strings indicating the variables making up
the first subcomposition of the ternary system. If omitted, the first
component of X is used instead.}

\item{y}{second (set of) variables}

\item{z}{third (set of) variables}
}
\value{
an object of class \code{ternary}, i.e. a
list containing:

xyz: a three column matrix (or vector) of ternary compositions.

and (if X is of class \code{SRDcorrected})

restoration: a list of intermediate ternary compositions inherited
from the SRD correction
}
\description{
Create an object of class \code{ternary}
}
\examples{
data(Namib)
tern <- ternary(Namib$PT,c('Q'),c('KF','P'),c('Lm','Lv','Ls'))
plot(tern,type="QFL")
}
\seealso{
restore
}

