% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/kde.R
\name{KDE}
\alias{KDE}
\title{Create a kernel density estimate}
\usage{
KDE(x, from = NA, to = NA, bw = NA, adaptive = TRUE, log = FALSE, ...)
}
\arguments{
\item{x}{a vector of numbers}

\item{from}{minimum age of the time axis. If NULL, this is set
automatically}

\item{to}{maximum age of the time axis. If NULL, this is set
automatically}

\item{bw}{the bandwidth of the KDE. If NULL, bw will be calculated
automatically using \code{botev()}}

\item{adaptive}{boolean flag controlling if the adaptive KDE
modifier of Abramson (1982) is used}

\item{log}{transform the ages to a log scale if TRUE}

\item{...}{optional arguments to be passed on to \code{density}}
}
\value{
an object of class \code{KDE}, i.e. a list
containing the following items:

x: horizontal plot coordinates

y: vertical plot coordinates

bw: the base bandwidth of the density estimate

ages: the data values from the input to the \code{KDE} function
}
\description{
Turns a vector of numbers into an object of class \code{KDE} using
a combination of the Botev (2010) bandwidth selector and the
Abramson (1982) adaptive kernel bandwidth modifier.
}
\examples{
data(Namib)
samp <- Namib$DZ$x[['N1']]
dens <- KDE(samp,0,3000,kernel="epanechnikov")
plot(dens)
}
\seealso{
KDEs
}

