% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_scored_mlm.R
\name{z_scored_mlm}
\alias{z_scored_mlm}
\title{Z-scored for multilevel analyses}
\usage{
z_scored_mlm(data, cols, group, keep_original = TRUE)
}
\arguments{
\item{data}{A data.frame or a data.frame extension (e.g. a tibble).}

\item{cols}{Columns that need to be centered. See `dplyr::dplyr_tidy_select` for available options.}

\item{group}{The grouping/cluster variable.}

\item{keep_original}{default is `TRUE`. Set to `FALSE` to remove original columns}
}
\value{
An object of the same type as .data. The output has the following properties:
1. Columns from .data will be preserved  
2. Columns with L1 scores that are group-mean centered then grand-mean z-scored.
3. Columns with L2 aggregated means that are z-scored
}
\description{
This function will group mean centered the scores at the level 1 and create an aggregated mean score for each group at L2. 
After that, the group-mean-centered L1 scores and mean L2 scores will be z-scored with respect to the grand mean. 
Please see `center_mlm` if you want to use the version without the z-scoring.
}
\examples{
z_scored_mlm(iris,dplyr::ends_with('Length'),group = 'Species')

}
