% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_d_order2.R
\name{ma_d_order2}
\alias{ma_d_order2}
\title{Second-order meta-analysis function for \emph{d} values}
\usage{
ma_d_order2(k, N = NULL, d = NULL, delta = NULL, var_d = NULL,
  var_d_c = NULL, ma_type = c("bb", "ic", "ad"), sample_id = NULL,
  citekey = NULL, moderators = NULL, moderator_type = "simple",
  construct_x = NULL, construct_y = NULL, conf_level = 0.95,
  cred_level = 0.8, conf_method = "t", cred_method = "t",
  var_unbiased = TRUE, hs_override = FALSE, data = NULL)
}
\arguments{
\item{k}{Vector or column name of meta-analyses' k values.}

\item{N}{Vector or column name of meta-analyses' total sample sizes (optional).}

\item{d}{Vector or column name of mean observed \emph{d} values.}

\item{delta}{Vector or column name of mean corrected \emph{d} values.}

\item{var_d}{Vector or column name of observed variances of observed \emph{d} values.}

\item{var_d_c}{Vector or column name of observed variances of corrected \emph{d} values.}

\item{ma_type}{Type of meta-analyses being analyzed: "bb" (barebones), "ic" (individual correction), or "ad" (artifact distribution).}

\item{sample_id}{Vector or column name of study ID labels.}

\item{citekey}{Optional vector of bibliographic citation keys for samples/studies in the meta-analysis (if multiple citekeys pertain to a given effect size, combine them into a single string entry with comma delimiters (e.g., "citkey1,citekey2").}

\item{moderators}{Matrix or column names of moderator variables to be used in the meta-analysis (can be a vector in the case of one moderator).}

\item{moderator_type}{Type of moderator analysis ("none", "simple", or "hierarchical").}

\item{construct_x}{Vector or column name of construct names for X.}

\item{construct_y}{Vector or column name of construct names for Y.}

\item{conf_level}{Confidence level to define the width of the confidence interval (default = .95).}

\item{cred_level}{Credibility level to define the width of the credibility interval (default = .80).}

\item{conf_method}{Distribution to be used to compute the width of confidence intervals. Available options are "t" for \emph{t} distribution or "norm" for normal distribution.}

\item{cred_method}{Distribution to be used to compute the width of credibility intervals. Available options are "t" for \emph{t} distribution or "norm" for normal distribution.}

\item{var_unbiased}{Logical scalar determining whether variances should be unbiased (\code{TRUE}) or maximum-likelihood (\code{FALSE}).}

\item{hs_override}{When \code{TRUE}, this will override settings for \code{conf_method} (will set to "norm"), \code{cred_method} (will set to "norm"), and \code{var_unbiased} (will set to \code{FALSE}).}

\item{data}{Data frame containing columns whose names may be provided as arguments to vector arguments and/or moderators.}
}
\value{
An object of the classes \code{psychmeta}, \code{ma_d_as_d}, \code{ma_order2}, and \code{ma_bb}, \code{ma_ic}, and/or \code{ma_ad}.
}
\description{
This function computes second-order meta-analysis function for \emph{d} values. It supports second-order analyses of bare-bones, artifact-distribution, and individual-correction meta-analyses.
}
