% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_prods.R
\name{estimate_prod}
\alias{estimate_prod}
\alias{estimate_mean_prod}
\alias{estimate_var_prod}
\alias{estimate_cov_prods}
\alias{estimate_cor_prods}
\title{Estimation of statistics computed from products of random, normal variables}
\usage{
estimate_mean_prod(mu_x, mu_y, cov_xy)

estimate_var_prod(mu_x, mu_y, var_x, var_y, cov_xy)

estimate_cov_prods(mu_x, mu_y, mu_u, mu_v, cov_xu, cov_xv, cov_yu, cov_yv)

estimate_cor_prods(mu_x, mu_y, mu_u, mu_v, var_x, var_y, var_u, var_v,
  cov_xu, cov_xv, cov_yu, cov_yv, cov_xy, cov_uv)
}
\arguments{
\item{mu_x}{Expected value of variable x.}

\item{mu_y}{Expected value of variable y.}

\item{cov_xy}{Covariance between x and y.}

\item{var_x}{Variance of variable x.}

\item{var_y}{Variance of variable y.}

\item{mu_u}{Expected value of variable u.}

\item{mu_v}{Expected value of variable v.}

\item{cov_xu}{Covariance between x and u.}

\item{cov_xv}{Covariance between x and v.}

\item{cov_yu}{Covariance between y and u.}

\item{cov_yv}{Covariance between y and v.}

\item{var_u}{Variance of variable u.}

\item{var_v}{Variance of variable v.}

\item{cov_uv}{Covariance between u and v.}
}
\value{
An estimated statistic computed from the products of random, normal variables.
}
\description{
This family of functions computes univariate descriptive statistics for the products of two variables denoted as "x" and "y" (e.g., mean(x * y) or var(x * y)) and
the covariance between the products of "x" and "y" and of "u" and "v" (e.g., cov(x * y, u * v) or cor(x * y, u * v)). These functions presume all variables are random normal variables.

Available functions include:
\itemize{
\item{estimate_mean_prod}{\cr Estimate the mean of the product of two variables: x * y.}
\item{estimate_var_prod}{\cr Estimate the variance of the product of two variables: x * y.}
\item{estimate_cov_prods}{\cr Estimate the covariance between the products of two pairs of variables: x * y and u * v.}
\item{estimate_cor_prods}{\cr Estimate the correlation between the products of two pairs of variables: x * y and u * v.}
}
}
\references{
Bohrnstedt, G. W., & Goldberger, A. S. (1969). On the exact covariance of products of random variables.
\emph{Journal of the American Statistical Association, 64}(328), 1439. \url{https://doi.org/10.2307/2286081}

Goodman, L. A. (1960). On the exact variance of products.
\emph{Journal of the American Statistical Association, 55}(292), 708. \url{https://doi.org/10.2307/2281592}
}
