% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{manylabs2018}
\alias{manylabs2018}
\title{Studies from the Many Labs 2 project.}
\format{
A dataset with 1,414 rows and 23 variables.
\itemize{
\item \code{lab}: The lab which conducted the replication
\item \code{es_id}: Unique id for each effect size
\item \code{yi_r}: A numeric indicating  the observed effect size, expressed in r
\item \code{vi_r}: A numeric indicating the variance on the observed effect size, expressed in r
\item \code{yi_d}: A numeric indicating the observed effect size, expressed in Cohen's d
\item \code{vi_d}: A numeric indicating the variance on the observed effect size, expressed in Cohen's d
\item \code{ni}: A numeric indicating the total sample size for the observed effect size
\item \code{country}: Country where the sample was collected
\item \code{weird}: Dummy variable encoding whether a country was classified as WEIRD; 0 = non-WEIRD, 1 = WEIRD
\item \code{western}: Dummy variable encoding a team judgment whether country was considered "western"
\item \code{educated}: Education score as measured by the Education Index
\item \code{industrialized}: Industrialization score as measured in the 2016 Industrial Development Report
\item \code{rich}: Dummy variable encoding whether a country is developed according to the 2014 World Economic Situation and Prospects Report; 0 = emerging or in transition, 1 = developed
\item \code{democratic}: The quality democracy in the corresponding country according to the 2015 Democracy Ranking Report. Higher scores indicate higher quality.
\item \code{mean_weird_score}: The arithmetic mean of the \code{weird}, \code{western}, \code{educated}, \code{industrialized}, and \code{rich} variables
\item \code{online}: Whether the study was replicated in a lab or online
\item \code{analysis}: Unique id for replicated study
}
}
\source{
\href{https://osf.io/ux3eh/}{https://osf.io/ux3eh/}
}
\usage{
data(manylabs2018)
}
\description{
A subset of the data collected in the Many Labs 2 project which conducted replications of 28 classic and contemporary findings in psychology.
The study examined the extent to which variability in replication success can be attributed to the study sample.
}
\references{
Klein, R. A., et al. (2018). Many Labs 2: Investigating variation in replicability across samples and settings.
\emph{Advances in Methods and Practices in Psychological Science}, \emph{1}(4), 443-490.
(\href{https://www.psychologicalscience.org/publications/many-labs-2}{APS})
}
\keyword{datasets}
