% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize.data.frame}
\alias{standardize.data.frame}
\title{Standardize (scale and reduce) Dataframe.}
\usage{
\method{standardize}{data.frame}(x, subset = NULL, except = NULL,
  normalize = FALSE, ...)
}
\arguments{
\item{x}{Dataframe.}

\item{subset}{Character or list of characters of column names to be
standardized.}

\item{except}{Character or list of characters of column names to be excluded
from standardization.}

\item{normalize}{Will perform a normalization instead of a standardization. This scales all numeric variables in the range 0 - 1.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
Dataframe.
}
\description{
Selects numeric variables and standardize (Z-score, "normalize") them.
}
\examples{
\dontrun{
df <- data.frame(
  Participant = as.factor(rep(1:25,each=4)),
  Condition = base::rep_len(c("A", "B", "C", "D"), 100),
  V1 = rnorm(100, 30, .2),
  V2 = runif(100, 3, 5),
  V3 = rnorm(100, 100, 10)
  )

dfZ <- standardize(df)
dfZ <- standardize(df, except="V3")
dfZ <- standardize(df, except=c("V1", "V2"))
dfZ <- standardize(df, subset="V3")
dfZ <- standardize(df, subset=c("V1", "V2"))
dfZ <- standardize(df, normalize=TRUE)

# Respects grouping
dfZ <- df \%>\%
  dplyr::group_by(Participant) \%>\%
  standardize(df)
}

}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
