% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{interpret_d_posterior}
\alias{interpret_d_posterior}
\title{Standardized difference (Cohen's d) interpreation for a posterior distribution.}
\usage{
interpret_d_posterior(posterior, rules = "cohen1988")
}
\arguments{
\item{posterior}{Posterior distribution of standardized differences.}

\item{rules}{Can be "cohen1988" (default), "sawilowsky2009", or a custom list.}
}
\description{
Interpret d with a set of rules.
}
\examples{
library(psycho)
posterior <- rnorm(1000, 0.6, 0.05)
interpret_d_posterior(posterior)
interpret_d_posterior(rnorm(1000, 0.1, 1))
}
\author{
\href{https://dominiquemakowski.github.io/}{Dominique Makowski}
}
