% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetDryAirDensity}
\alias{GetDryAirDensity}
\title{Return dry-air density given dry-bulb temperature and pressure.}
\usage{
GetDryAirDensity(TDryBulb, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of dry air density in lb ft-3 [IP] or kg m-3 [SI]
}
\description{
Return dry-air density given dry-bulb temperature and pressure.
}
\examples{
SetUnitSystem("IP")
GetDryAirDensity(77:87, 14.696)

SetUnitSystem("SI")
GetDryAirDensity(25:30, 101325)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1
\itemize{
  \item Eqn 14 for the perfect gas relationship for dry air.
  \item Eqn 1 for the universal gas constant.
  \item The factor 144 in IP is for the conversion of Psi = lb in-2 to lb ft-2.
}
}
