% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics-utils.R
\name{pairwise_t_test}
\alias{pairwise_t_test}
\title{Pairwise t-test}
\usage{
pairwise_t_test(formula, data, p_adj = "bonferroni")
}
\arguments{
\item{formula}{A two sided formula with one variable on either side, e.g. y ~
x, where the left hand side, dependent, variable is a numeric variable in
\code{data} and the right hand side, independent, variable is a categorical or
factor variable in \code{data}.}

\item{data}{A data frame that contains the dependent and independent
variables.}

\item{p_adj}{The p-value adjustment method (see Description).}
}
\value{
An object of class \code{pairwise.htest} as returned by \code{\link[stats:pairwise.t.test]{stats::pairwise.t.test()}}.
}
\description{
This is wrapper to the \code{pairwise.t.test} function. The p-value adjustment is
"bonferroni" by default. Other possible values are "holm", "hochberg",
"hommel", "BH", "BY", "fdr", "none". See \code{\link[stats:p.adjust]{stats::p.adjust()}}.
}
\examples{
data_df <- dplyr::mutate(vizverb, IV = interaction(task, response))
pairwise_t_test(time ~ IV, data = data_df)

}
