% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accdpx.R
\name{res.dpx}
\alias{res.dpx}
\title{Residue Depth Analysis}
\usage{
res.dpx(pdb, aa = 'all')
}
\arguments{
\item{pdb}{is either a PDB id, or the path to a pdb file.}

\item{aa}{one letter code for the amino acid of interest, or 'all' for all the protein residues.}
}
\value{
A dataframe with the computed depths.
}
\description{
Computes the depth from the surface for each protein's residue.
}
\details{
This function computes the depth, defined as the distance in angstroms between the residue and the closest atom on the protein surface.
}
\examples{
\dontrun{res.dpx('1cll')}
}
\references{
Pintar et al. 2003. Bioinformatics 19:313-314 (PMID: 12538266)
}
\seealso{
atom.dpx(), acc.dssp(), str.part()
}
\author{
Juan Carlos Aledo
}
