% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_enable.R
\name{log_enable}
\alias{log_enable}
\title{log_enable}
\usage{
log_enable(
  logfile_loc = NULL,
  pos = 1,
  logger_nm = my_logger,
  appender_nm = file_app
)
}
\arguments{
\item{logfile_loc}{The path to the logfile. Suggested use "logs/logfile.txt".}

\item{pos}{The environment which to assign pipeline_message. Defaults to 1,
equivalent to the .GlobalEnv.}

\item{logger_nm}{What to call the logger. Provide unquoted strings with no
spaces. Defaults to my_logger.}

\item{appender_nm}{What to call the appender function. Provide unquoted
strings with no spaces. Defaults to file_app.}
}
\value{
Creates logger and file appender.
}
\description{
Assigns the necessary global scope objects for logging with "log4r".
}
\examples{
\dontshow{.old_wd <- setwd(tempdir())}

# create logging infrastructure
log_file_ops(dir_path = "logs/logfile.txt")
# enable logging
log_enable(logfile_loc = "logs/logfile.txt")

# tidy up environment
unlink("logs", recursive = TRUE)

\dontshow{setwd(.old_wd)}

}
