% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fake_data.R
\name{makedynamics_general}
\alias{makedynamics_general}
\title{Simulate general time series}
\usage{
makedynamics_general(
  n = 1000,
  n0 = 0.1,
  pdet = c(log(3), log(1)),
  proc = c(log(1)),
  obs = c(log(1)),
  pcol = c(logit(0.2), log(1)),
  detfun = detfun0,
  procfun = procfun0,
  obsfun = obsfun0,
  colfun = colfun0,
  doplot = FALSE
)
}
\arguments{
\item{n}{number of timesteps to simulate}

\item{n0}{starting population size}

\item{pdet}{a numeric vector of parameters for the deterministic function}

\item{proc}{a numeric vector of parameters for the process noise function}

\item{obs}{a numeric vector of parameters for the observation error function}

\item{pcol}{a numeric vector of parameters for the colonization function}

\item{detfun}{A function that simulates deterministic dynamics, which takes in arguments sdet (parameters for deterministic model, taken from pars$proc), and xt, observed abundances at time t. Returns estimated abundances at time t+1 based on deterministic function (either a parametric function or an EDM function). Defaults to detfun0.}

\item{procfun}{A function that simulates process noise, which takes in arguments sp (parameters for process noise function, taken from pars$proc) and xt (abundances prior to process noise). Returns abundances after process noise has occurred. Defaults to procfun0.}

\item{obsfun}{An observation function, which takes in up to five variables, including so (a vector of parameter values, inherited from pars$obs), yt (a number, showing observed abundance at time t), xt (predicted abundances), binary value "inverse", and number "N". If inverse = TRUE,
then function should simulate N draws from the observation function, centered around value yt. If inverse = FALSE, then function should return log probability denisty of observed value yt given predicted values in xt. Defaults to obsfun0.}

\item{colfun}{A function simulating colonization events, that takes in two arguments: co, a vector of parameter values taken from pars$pcol, and xt, a number or numeric vector of abundances at time t, before colonization has occurred. Returns predicted abundances after colonization has occurred. Defaults to colful0.}

\item{doplot}{a logical specifying wether output should be plotted - defaults to FALSE}
}
\value{
An n-by-3 dataframe of states, including obs (observed values), truth (true values), and noproc (values without process noise)
}
\description{
Simulates a time series following a user-defined deterministic function, observation function, process noise function, and colonization function.
}
\examples{
 #run function
 datout<-makedynamics_general(n=2e4, proc = c(-2,log(1.2)))

 #show regression of variance vs. mean for binned data
 datout_ps<-datout[datout$true>0 & datout$noproc>0,]
 #bins
 sq<-seq(0, quantile(datout$true, 0.95), length=50)
 ctd<-cut(datout_ps$noproc, sq)
 #calculate mean and variance by bin
 tdat<-data.frame(mu=(sq[-1]+sq[-length(sq)])/2,
      var=tapply((datout_ps$true-datout_ps$noproc)^2, ctd, mean))
 #plot result
 plot(log(tdat$mu), log(tdat$var), xlab="mu", ylab="var")
 #show regression
 summary(mod<-lm(log(var)~log(mu), tdat)); abline(mod, col=2)
}
\keyword{Taylor}
\keyword{law}
\keyword{power}
\keyword{stability}
\keyword{time-series}
