% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patterns.R
\name{patterns}
\alias{patterns}
\title{Stopping pattern for a given run}
\usage{
patterns(
  run_id,
  route_type,
  stop_id = NULL,
  departs = Sys.time(),
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{run_id}{An integer run ID. This may retrieved from the \code{departures}
or \code{runs_on_route} functions.}

\item{route_type}{Optionally filter results by a route type. A route type can
be provided either as a non-negative integer code, or as a character:
"Tram", "Train", "Bus", "Vline" or "Night Bus". Character inputs are not
case-sensitive. Use the \code{route_types} function to extract a vector of all
route types.}

\item{stop_id}{Integer. Optionally filter results to a specific stop ID.
These can be searched for with the \code{stops_on_route} and \code{stops_nearby}
functions.}

\item{departs}{POSIXct or character. Optionally filter by date. See Details.
Characters are automatically converted to departs, and are assumed to be
given as Melbourne time. The behaviour of the API is unpredictable when
using this argument --- see details. Defaults to the current system time.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
An object of class "ptvapi", which is effectively a list with the
following names: \itemize{ \item \code{departures} \item \code{stops} \item \code{routes}
\item \code{runs} \item \code{directions} \item \code{disruptions} }
}
\description{
A pattern consists of all departures, stops, routes, runs, directions and
disruptions associated with a particular run ID. This is returned as a list
of tibbles, with output corresponding to their respective API calls.
}
\details{
The \code{stops} tibble has an output similar to that returned by
\code{stops_on_route}. The \code{routes} tibble does not contain service status
information.

Departures: The API seems to return the earliest 7 departures. While
the PTV Timetable API supports filtering patterns by datetimes, the
behaviour of this argument is not reliable --- it appears to filter by day
only, returning the earliest 7 departures of a different day. It is
recommended that departures are retrieved via the \code{departures} function.
}
\examples{
\dontrun{
patterns(run_id = 1, route_type = 0)
patterns(run_id = 1, route_type = "Train")
}

}
