% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{ptv_search}
\alias{ptv_search}
\title{Use a character term to search for routes, stops, and outlets.}
\usage{
ptv_search(
  search_term,
  latitude = NULL,
  longitude = NULL,
  max_distance = NULL,
  route_types = NULL,
  include_outlets = FALSE,
  match_stop_by_suburb = FALSE,
  match_route_by_suburb = FALSE,
  match_stop_by_gtfs_stop_id = FALSE,
  user_id = determine_user_id(),
  api_key = determine_api_key()
)
}
\arguments{
\item{search_term}{Character. Term used to perform search.}

\item{latitude}{Numeric. Latitude in decimal degrees. For example, Flinders
Street Station is at approximately -37.8183 latitude.}

\item{longitude}{Numeric. Longitude in decimal degrees. For example, Flinders
Street Station is at approximately 144.9671 longitude.}

\item{max_distance}{Integer. Optionally filter by maximum distance from the
given location, in metres.}

\item{route_types}{Integer or character vector. Optionally filter by a vector
of route types. A route type can be provided either as a non-negative
integer code, or as a character: "Tram", "Train", "Bus", "Vline" or "Night
Bus". Character inputs are not case-sensitive. Use the \code{route_types}
function to extract a vector of all route types.}

\item{include_outlets}{Boolean. Optional. Affects search results.}

\item{match_stop_by_suburb}{Boolean. Optional. Affects search results.}

\item{match_route_by_suburb}{Boolean. Optional. Affects search results.}

\item{match_stop_by_gtfs_stop_id}{Boolean. Optional. Affects search results.}

\item{user_id}{Integer or character. A user ID or devid provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}

\item{api_key}{Character. An API key, with dashes, provided by Public
Transport Victoria. Refer to \code{?ptvapi} for more details.}
}
\value{
The response of the \code{search} API call.
}
\description{
There's only one search API call, and it covers stops, routes, and outlets.
This function will return the response of this generic search. It is
expected that other functions will take on of these three categories of
search results, parse them, and return them to the user as a tibble.
}
\details{
If the search term is numeric and/or less than 3 characters, the API will
return only routes. By default, as little matching is done as possible, and
as little as possible is returned. We rely on functions that call on this
function to specify what is needed.
}
\keyword{internal}
