% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_functions.R
\name{reference_range}
\alias{reference_range}
\title{Reference range (reference interval).}
\usage{
reference_range(avg, std)
}
\arguments{
\item{avg}{The arithmetic mean (a scalar numerical value).}

\item{std}{The standard deviation (a scalar numerical value).}
}
\value{
A data frame with the reference range limits.
}
\description{
\code{reference_range} estimates the reference range (reference interval) of a numerical variable.
}
\details{
The reference range assumes normality and represents the limits that would include 95% of the expected
observations.
}
\examples{
x <- rnorm(100, 170, 8)
round(mean(x), 2)
round(sd(x), 2)

round(reference_range(mean(x), sd(x)), 2)
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.
}
