% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{box_plot}
\alias{box_plot}
\title{Construct "pretty" box plots in lattice.}
\usage{
box_plot(formula, data, box.fill = "gray70", box.ratio = 0.7,
  aspect = 3/4, ...)
}
\arguments{
\item{formula}{A formula of the form \code{y ~ x} where \code{y} is a numerical variable and \code{x} is a factor.}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{box.fill}{Colour used for the box passed to \link{bwplot}.}

\item{box.ratio}{Ratio of box passed to \link{bwplot}.}

\item{aspect}{Physical aspect ratio passed to \link{bwplot}.}

\item{...}{Further arguments passed to \link{bwplot}.}
}
\description{
\code{box_plot} is a wrap function that calls \link{bwplot} to construct more aesthetic box plots.
}
\examples{
data(kfm, package = "ISwR")
box_plot(dl.milk ~ sex, data = kfm, ylab = "Breast-milk intake (dl/day)")
}
\author{
Josie Athens, Department of Preventive and Social Medicine, University of Otago, New Zealand.

Deepayan Sarkar, R-Core.
}
