% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulver.R
\name{pulverize_all}
\alias{pulverize_all}
\title{pulverize_all}
\usage{
pulverize_all(ys, xs, zs, output_file = NULL, colnames = c("y", "x", "z"),
  pvalue_threshold = 1, cores = 1L, overwrite = FALSE,
  suppress_return = TRUE)
}
\arguments{
\item{ys, xs, zs}{lists of input file names (text or \code{databel} object file)
containing tab-separated tables or matrices of type "double"}

\item{output_file}{Output file name (default: \code{NULL})}

\item{colnames}{Column names of output file (default: "y", "x", and "z")}

\item{pvalue_threshold}{p-value threshold (default: NULL, see \code{\link{pulverize}})}

\item{cores}{Number of cores (default: 1, see \code{\link{pulverize}})}

\item{overwrite}{If \code{TRUE} overwrite \code{output_file} (default: \code{FALSE})}

\item{suppress_return}{If TRUE return NULL instead of a data
frame with p-values for the interaction term (default: \code{TRUE})}
}
\description{
Call \code{\link{pulverize}} for all combinations of input files.
}
\details{
\code{pulverize_all} iterates through lists of file names or list
    of matrices and calls \code{pulverize} for each combination. Files must contain
    matrices with the same number of rows (= number of observations) and must have
    column names.

    By default all results are written to \code{output_file} without
    returning a data frame (\code{suppress_return} = \code{TRUE}). Column names
    of the output file are by default set to "y", "x", and "z", but can be changed
    using the \code{colnames} argument. Furthermore, by default, \code{output_file} cannot
    be overwritten. For enabling overwrite of an existing \code{output_file}, set
    \code{overwrite} to \code{TRUE}.
}
\examples{
#generate files
nobs <- 100
y <- matrix(rnorm(nobs * 2), ncol = 2, dimnames = list(NULL,
paste0("column", 1:2)))
write.table(y, file = "y.txt", sep = "\\t")
write_databel(y, "y")
x <- matrix(rnorm(nobs * 3), ncol = 3, dimnames = list(NULL,
paste0("column", 1:3)))
write.table(x, file = "x.txt", sep = "\\t")
z <- matrix(rnorm(nobs * 4), ncol = 4, dimnames = list(NULL,
paste0("column", 1:4)))
write.table(z, file = "z.txt", sep = "\\t")

#run pulverize_all with generated files
pulverize_all(as.list("y.txt", "y.fvi"), as.list("x.txt"), as.list("z.txt"),
suppress_return = FALSE)

#remove generated files
file.remove("x.txt", "y.txt", "z.txt", "y.fvi", "y.fvd")

}
\seealso{
\code{\link{pulverize}}
}
