% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indt.R
\name{indt}
\alias{indt}
\title{Compute power for an Independent Samples t-test
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user}
\usage{
indt(
  m1 = NULL,
  m2 = NULL,
  s1 = NULL,
  s2 = NULL,
  n1 = NULL,
  n2 = NULL,
  alpha = 0.05
)
}
\arguments{
\item{m1}{Mean of first group}

\item{m2}{Mean of second group}

\item{s1}{Standard deviation of first group}

\item{s2}{Standard deviation of second group}

\item{n1}{Sample size for first group}

\item{n2}{Sample size for second group}

\item{alpha}{Type I error (default is .05)}
}
\value{
Power for Independent Samples t-test
}
\description{
Compute power for an Independent Samples t-test
Takes means, sds, and sample sizes for each group. Alpha is .05 by default, alternative values may be entered by user
}
\examples{
indt(m1=22,m2=20,s1=5,s2=5,n1=99,n2=99)
indt(m1=1.3, m2=0, s1=4,s2=1,n1=78,n2=234)
}
