% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_rjust.R
\name{pystr_rjust}
\alias{pystr_rjust}
\title{Right justify a string.}
\usage{
pystr_rjust(str, width, fillchar = " ")
}
\arguments{
\item{str}{A string.}

\item{width}{An integer.}

\item{fillchar}{A character.}
}
\value{
A string.
}
\description{
Return \code{str} right justified in a string of length \code{width}.
Padding is done using the specified \code{fillchar} (default is an ASCII space).
The original string is returned if \code{width} is less than or equal to \code{nchar(str)}.
}
\examples{
pystr_rjust("right", 10)
pystr_rjust("right", 10, "*")
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.rjust}
}
\seealso{
\code{\link{pystr_ljust}}
}

