% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pystr_replace.R
\name{pystr_replace}
\alias{pystr_replace}
\title{Replace substrings within a string.}
\usage{
pystr_replace(str, old, new, count = nchar(str) + 2)
}
\arguments{
\item{str}{A character vector.}

\item{old}{A character vector.}

\item{new}{A character vector.}

\item{count}{A numeric vector.}
}
\value{
A character vector.
}
\description{
Return a copy of the string with all occurrences of substring \code{old} replaced by \code{new}.
}
\details{
If the optional argument \code{count} is given, only the first \code{count} occurrences are replaced.
}
\examples{
pystr_replace("123123123", "2", "two")
pystr_replace("123123123", "2", "two", 2)
}
\references{
\url{https://docs.python.org/3/library/stdtypes.html#str.replace}
}

