% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalCurve.R
\name{CalCurve}
\alias{CalCurve}
\title{Standard Curve Calculation.}
\arguments{
\item{cq.table}{The data frame of the position and Cq value.}

\item{concen.table}{The data frame of the position and concentration.}

\item{highest.concen}{The highest concentration for calculation.}

\item{lowest.concen}{The lowest concentration for calculation.}

\item{dilution}{Dilution factor of cDNA template. The default value is 4.}

\item{by.mean}{Calculation by mean Cq value or not. The default value is TRUE.}
}
\value{
A list.
}
\description{
The function can calculate the standard curve.
At the same time, it can get the amplification efficiency of primer(s).
Based on the amplification efficiency, we can know which method can be
used to calculate the expression level.
}
\examples{
df.1.path <- system.file("examples", "calsc.cq.txt", package = "qPCRtools")
df.2.path <- system.file("examples", "calsc.info.txt", package = "qPCRtools")
df.1 <- data.table::fread(df.1.path)
df.2 <- data.table::fread(df.2.path)
CalCurve(
  cq.table = df.1,
  concen.table = df.2,
  lowest.concen = 4,
  highest.concen = 4096,
  dilu = 4,
  by = "mean"
) -> p

p[["table"]]
p[["figure"]]
}
\author{
Xiang LI <lixiang117423@gmail.com>
}
