% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standardize.R
\name{standardize}
\alias{standardize}
\title{Standardize numeric variables}
\usage{
standardize(data, mean = 0, sd = 1, include_dummy = FALSE)
}
\arguments{
\item{data}{a data frame.}

\item{mean}{mean of the transformed variables.}

\item{sd}{standard deviation of the transformed variables.}

\item{include_dummy}{logical. If \code{TRUE}, transform
dummy coded (0,1) variables.}
}
\value{
a data frame
}
\description{
Standardize the numeric variables in a data frame
}
\details{
\code{standardize} transforms all the numeric variables
in a data frame to have the same mean and standard deviation.
By default, this will be a mean of 0 and standard deviation of 1.
Character variables and factors are left unchanged. By default,
dummy coded variables are also left unchanged. Use
\code{include_dummy=TRUE} to transform these variables as well.
}
\examples{
head(cars74)

cars74_st <- standardize(cars74)
head(cars74_st)
}
