% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_qcpm.R
\name{qcpm}
\alias{qcpm}
\title{QC-PM: Quantile Composite-based Path Modeling}
\usage{
qcpm(
  model,
  data,
  scheme = "factorial",
  tau = NULL,
  fix.quantile = FALSE,
  qcorr = FALSE,
  tol = 1e-05,
  maxiter = 100
)
}
\arguments{
\item{model}{A description of the user-specified model. The model is described using 
the the lavaan sintax or cSEM sintax. Structural and measurement model are defined 
enclosed between double quotes. The causal link between constructs is defined by 
using the tilde ("~") operator. On the left-hand side of the operator there is the 
dependent constructand on the right-hand sideconstruct there are the explanatory 
constructs, separated by the ("+") operator. Regarding the measurement model, 
each construct must be defined, listing their indicators and indicating the way 
outer weights are computed in the iterative algorithm: mode Amode B. Mode A is 
defined by using the special operator ("=~"); Mode B is defined by using the special 
operator ("<~"). On the left-hand side of the operator, we have the cosntruct and on 
the right-hand side we have the MVs, separated by the ("+") operator. Variables labels 
cannot contain (".").}

\item{data}{is a data frame or a data matrix (statistical units x manifest variables).}

\item{scheme}{is a string indicating the type of inner weighting scheme. It is equal to 
\code{factorial} by default. Possible values are \code{centroid} or \code{factorial}.}

\item{tau}{indicates the specific quantile that must be considered for the estimation. 
It is equal to \code{NULL} by default. When defined, this value is used instead of the default 
values (0.25, 0.5, 0.75).}

\item{fix.quantile}{is a boolean. When equal to \code{TRUE}, the quantile used in the outer step of the 
iterative algorithm is fixed to 0.5. It is used when measurement invariance is an issue. 
It is equal to \code{FALSE} by default.}

\item{qcorr}{is a boolean. If it si equal to \code{TRUE}, loadings are estimated by using quantile 
correlations. By default it is equal to \code{FALSE}.}

\item{tol}{is a decimal value indicating the tolerance criterion for the iterations (tol=0.00001
by default).}

\item{maxiter}{integer indicating the maximum number of iterations (maxiter=100 by default).}
}
\value{
An object of class \code{qcpm}.

\item{outer.weights}{the outer weights estimated for each considered quantile.}

\item{outer.loadings}{the outer loadings estimated for each considered quantile.}

\item{path.coefficients}{the path coefficients estimated for each considered quantile.}

\item{latent.scores}{list of the component scores for each considered quantile.}

\item{data}{original dataset used for the analysis.}

\item{model}{internal parameters related to the model estimation.}
}
\description{
\code{qcpm}  estimates path model paramters by quantile composite-based  
path modelling approach.
}
\details{
Users can choose to estimate the model parameters for a specific quantile (tau) or to 
use the default quantile values: tau = (0.25, 0,50, 0.75). It is also possible to fix 
the quantile to 0.5 in the outer step of the iterative algorithm by using the parameter 
\code{fix.quantile = TRUE} for handling the measurement invariance issue (Dolce et al. 2021; 
Henseler et al. 2016).
}
\examples{

# Example of QC-PM in Well-Being analysis
# model with three LVs and reflective indicators

# load library and dataset province
library(qcpm)
data(province)

# Define the model using laavan sintax. Use a set of regression formulas defining 
# firstly the structural model and then the measurement model
model <- "
# Structural model
EcoW ~ Edu
Health ~ Edu + EcoW

# Reflective measurement model
Edu =~ O22 + O23 + O24 + O25aa + O26 + O_27_28 + O_27_28_AA
EcoW =~ O41 + O44aa + O45 + O46aa + O42 + O43
Health =~  O11F + O11M + O12MEAN_aa
"

# Apply qcpm
well.qcpm = qcpm(model,province)
well.qcpm

}
\references{
Davino, C., Dolce, P., Taralli, S., Vistocco, D. (2020)  Composite-Based Path 
Modeling for Conditional Quantiles Prediction. An Application to Assess 
Health Differences at Local Level in a Well-Being Perspective. 
\emph{Social Indicator Research}, pp. 1-30, doi:10.1007/s11205-020-02425-5.

Davino, C., Vinzi, V.E. (2016) Quantile composite-based path
modeling. \emph{Advansed Data Analysis and Classification}, \bold{10}, pp. 
491-520, doi:10.1007/s11634-015-0231-9.

Dolce, P., Davino, C., Vistocco, D. (2021) Quantile composite-based path modeling: 
algorithms, properties and applications.\emph{Advansed Data Analysis and Classification},
doi:10.1007/s11634-021-00469-0.

Henseler J., Ringle C.M., Sarstedt M. (2016) Testingmeasurement invariance of 
composites using partial least squares. \emph{Internationa Marketing Review}, \bold{33(3)}, pp. 
405-431, doi:10.1108/IMR-09-2014-0304

Li G, Li Y, Tsai C (2014) Quantile correlations and quantile autoregressive modeling. 
\emph{Journal of the American Statistical Association}, \bold{110(509)} pp.233-245, 
doi: 10.1080/01621459.2014.892007
}
\seealso{
\code{\link{summary}}, \code{\link{assessment}}, \code{\link{boot}}, and 
\code{\link{reliability}}
}
\author{
Cristina Davino, Pasquale Dolce, Giuseppe Lamberti, Domenico Vistocco
}
