% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/condense.R
\name{condense}
\alias{condense}
\title{Condense Dataframe Columns}
\usage{
condense(dataframe, sep = ", ")
}
\arguments{
\item{dataframe}{A dataframe with a column(s) that are a list of vectors.}

\item{sep}{A character string to separate the terms.}
}
\value{
Returns a dataframe with condensed columns that can be wrote to
csv/xlsx.
}
\description{
Condense dataframe columns that are a list of vectors to a single vector of
strings.
}
\examples{
\dontrun{
library(qdap)
poldat <- with(DATA.SPLIT, polarity(state, person))
write.csv(x = condense(counts(poldat)), file = "foo.csv")
}
}
\seealso{
\code{\link[qdap]{mcsv_w}}
}

