% Generated by roxygen2 (4.0.2): do not edit by hand
\name{rm_percent}
\alias{rm_percent}
\title{Remove/Replace/Extract Percentages}
\usage{
rm_percent(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_percent", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_percent} uses the
\code{rm_percent} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the percentages are extracted into a
list of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with percentages removed.
}
\description{
Remove/replace/extract percentages from a string.
}
\examples{
x <-  c("There is $5.50 for me.", "that's 45.6\% of the pizza",
    "14\% is $26 or $25.99")

rm_percent(x)
rm_percent(x, extract=TRUE)
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}
}
\keyword{percent}

