% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rm_url.R
\name{rm_url}
\alias{ex_twitter_url}
\alias{ex_url}
\alias{rm_twitter_url}
\alias{rm_url}
\title{Remove/Replace/Extract URLs}
\usage{
rm_url(text.var, trim = !extract, clean = TRUE, pattern = "@rm_url",
  replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

rm_twitter_url(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_twitter_url", replacement = "", extract = FALSE,
  dictionary = getOption("regex.library"), ...)

ex_url(text.var, trim = !extract, clean = TRUE, pattern = "@rm_url",
  replacement = "", extract = TRUE,
  dictionary = getOption("regex.library"), ...)

ex_twitter_url(text.var, trim = !extract, clean = TRUE,
  pattern = "@rm_twitter_url", replacement = "", extract = TRUE,
  dictionary = getOption("regex.library"), ...)
}
\arguments{
\item{text.var}{The text variable.}

\item{trim}{logical.  If \code{TRUE} removes leading and trailing white
spaces.}

\item{clean}{trim logical.  If \code{TRUE} extra white spaces and escaped
character will be removed.}

\item{pattern}{A character string containing a regular expression (or
character string for \code{fixed = TRUE}) to be matched in the given
character vector.  Default, \code{@rm_url} uses the
\code{rm_url} regex from the regular expression dictionary from
the \code{dictionary} argument.}

\item{replacement}{Replacement for matched \code{pattern}.}

\item{extract}{logical.  If \code{TRUE} the URLs are extracted into a list
of vectors.}

\item{dictionary}{A dictionary of canned regular expressions to search within
if \code{pattern} begins with \code{"@rm_"}.}

\item{\dots}{Other arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a character string with URLs removed.
}
\description{
\code{rm_url} - Remove/replace/extract URLs from a string.

\code{rm_twitter_url} - Remove/replace/extract Twitter Short URLs from a
string.
}
\details{
The default regex pattern \code{"(http[^ ]*)|(www\\.[^ ]*)"} is more
liberal.  More constrained versions can be accessed
via \code{pattern = "@rm_url2"} & \code{pattern = "@rm_url3"} see
\bold{Examples}).
}
\examples{
x <- " I like www.talkstats.com and http://stackoverflow.com"
rm_url(x)
rm_url(x, replacement = '<a href="\\\\1" target="_blank">\\\\1</a>')
ex_url(x)

ex_url(x, pattern = "@rm_url2")
ex_url(x, pattern = "@rm_url3")

## Remove Twitter Short URL
x <- c("download file from http://example.com",
         "this is the link to my website http://example.com",
         "go to http://example.com from more info.",
         "Another url ftp://www.example.com",
         "And https://www.example.net",
         "twitter type: t.co/N1kq0F26tG",
         "still another one https://t.co/N1kq0F26tG :-)")

rm_twitter_url(x)
ex_twitter_url(x)

## Combine removing Twitter URLs and standard URLs
rm_twitter_n_url <- rm_(pattern=pastex("@rm_twitter_url", "@rm_url"))
rm_twitter_n_url(x)
rm_twitter_n_url(x, extract=TRUE)
}
\references{
The more constrained url regular expressions (\code{"@rm_url2"}
and \code{"@rm_url3"} was adapted from imme_emosol's response:
\url{https://mathiasbynens.be/demo/url-regex}
}
\seealso{
\code{\link[base]{gsub}},
\code{\link[stringi]{stri_extract_all_regex}}

Other rm_.functions: \code{\link{as_numeric}},
  \code{\link{as_numeric2}}, \code{\link{ex_number}},
  \code{\link{rm_number}}; \code{\link{as_time}},
  \code{\link{as_time2}}, \code{\link{ex_time}},
  \code{\link{ex_transcript_time}}, \code{\link{rm_time}},
  \code{\link{rm_transcript_time}};
  \code{\link{ex_abbreviation}},
  \code{\link{rm_abbreviation}}; \code{\link{ex_angle}},
  \code{\link{ex_bracket}},
  \code{\link{ex_bracket_multiple}},
  \code{\link{ex_curly}}, \code{\link{ex_round}},
  \code{\link{ex_square}}, \code{\link{rm_angle}},
  \code{\link{rm_bracket}},
  \code{\link{rm_bracket_multiple}},
  \code{\link{rm_curly}}, \code{\link{rm_round}},
  \code{\link{rm_square}}; \code{\link{ex_between}},
  \code{\link{ex_between_multiple}},
  \code{\link{rm_between}},
  \code{\link{rm_between_multiple}};
  \code{\link{ex_caps_phrase}},
  \code{\link{rm_caps_phrase}}; \code{\link{ex_caps}},
  \code{\link{rm_caps}}; \code{\link{ex_citation_tex}},
  \code{\link{rm_citation_tex}}; \code{\link{ex_citation}},
  \code{\link{rm_citation}};
  \code{\link{ex_city_state_zip}},
  \code{\link{rm_city_state_zip}};
  \code{\link{ex_city_state}}, \code{\link{rm_city_state}};
  \code{\link{ex_date}}, \code{\link{rm_date}};
  \code{\link{ex_default}}, \code{\link{rm_default}};
  \code{\link{ex_dollar}}, \code{\link{rm_dollar}};
  \code{\link{ex_email}}, \code{\link{rm_email}};
  \code{\link{ex_emoticon}}, \code{\link{rm_emoticon}};
  \code{\link{ex_endmark}}, \code{\link{rm_endmark}};
  \code{\link{ex_hash}}, \code{\link{rm_hash}};
  \code{\link{ex_nchar_words}},
  \code{\link{rm_nchar_words}}; \code{\link{ex_non_ascii}},
  \code{\link{rm_non_ascii}}; \code{\link{ex_non_words}},
  \code{\link{rm_non_words}}; \code{\link{ex_percent}},
  \code{\link{rm_percent}}; \code{\link{ex_phone}},
  \code{\link{rm_phone}}; \code{\link{ex_postal_code}},
  \code{\link{rm_postal_code}};
  \code{\link{ex_repeated_characters}},
  \code{\link{rm_repeated_characters}};
  \code{\link{ex_repeated_phrases}},
  \code{\link{rm_repeated_phrases}};
  \code{\link{ex_repeated_words}},
  \code{\link{rm_repeated_words}}; \code{\link{ex_tag}},
  \code{\link{rm_tag}}; \code{\link{ex_title_name}},
  \code{\link{rm_title_name}}; \code{\link{ex_white}},
  \code{\link{ex_white_bracket}},
  \code{\link{ex_white_colon}},
  \code{\link{ex_white_comma}},
  \code{\link{ex_white_endmark}},
  \code{\link{ex_white_lead}},
  \code{\link{ex_white_lead_trail}},
  \code{\link{ex_white_multiple}},
  \code{\link{ex_white_punctuation}},
  \code{\link{ex_white_trail}}, \code{\link{rm_white}},
  \code{\link{rm_white_bracket}},
  \code{\link{rm_white_colon}},
  \code{\link{rm_white_comma}},
  \code{\link{rm_white_endmark}},
  \code{\link{rm_white_lead}},
  \code{\link{rm_white_lead_trail}},
  \code{\link{rm_white_multiple}},
  \code{\link{rm_white_punctuation}},
  \code{\link{rm_white_trail}}; \code{\link{ex_zip}},
  \code{\link{rm_zip}}
}
\keyword{ftp}
\keyword{http}
\keyword{t.co}
\keyword{url}
\keyword{www}

