% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{KiK}
\alias{KiK}
\title{Matrix square root and generalized inverse}
\usage{
KiK(S, tol = .Machine$double.eps * 100)
}
\arguments{
\item{S}{Covariance matrix. Symmetry and positive (semi-)definiteness are checked.}

\item{tol}{Tolerance to determine the rank of \eqn{\mathbf{S}}.
Eigenvalues smaller than this value are considered zero.}
}
\value{
List with \code{K} and \code{iK}, with the latter being \eqn{\mathbf{K}^-}
}
\description{
This internal function calculates the decomposition
\eqn{\mathbf{S} = \mathbf{K} \mathbf{K}^T} for an \eqn{n \times n}
covariance matrix \eqn{\mathbf{S}}, so that \eqn{\mathbf{K}} is an
\eqn{n \times m} matrix with \eqn{m} being the rank of \eqn{\mathbf{S}}.
Returns this \eqn{\mathbf{K}} and its generalized inverse,
\eqn{\mathbf{K}^-}, in a list.
}
\details{
At present, this utilizes \code{svd()},
although there may be better alternatives.
}
