% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_zi.R
\name{zimsm.fit}
\alias{zimsm.fit}
\title{marginal structural zero-inflated count models (MSM) based on within quantile g-computation}
\usage{
zimsm.fit(
  f,
  qdata,
  intvals,
  expnms,
  main = TRUE,
  degree = 1,
  id = NULL,
  MCsize = 10000,
  containmix = list(count = TRUE, zero = TRUE),
  bayes = FALSE,
  x = FALSE,
  msmcontrol = zimsm.fit.control(),
  ...
)
}
\arguments{
\item{f}{an r formula representing the conditional model for the outcome, given all
exposures and covariates. Interaction terms that include exposure variables
should be represented via the \code{\link[base]{AsIs}} function}

\item{qdata}{a data frame with quantized exposures (as well as outcome and other covariates)}

\item{intvals}{sequence, the sequence of integer values that the joint exposure 
is 'set' to for estimating the msm. For quantile g-computation, this is just 
0:(q-1), where q is the number of quantiles of exposure.}

\item{expnms}{a character vector with the names of the columns in qdata that represent
the exposures of interest (main terms only!)}

\item{main}{logical, internal use: produce estimates of exposure effect (psi)
and expected outcomes under g-computation and the MSM}

\item{degree}{polynomial bases for marginal model (e.g. degree = 2
allows that the relationship between the whole exposure mixture and the outcome
is quadratic. Default=1)}

\item{id}{(optional) NULL, or variable name indexing individual units of 
observation (only needed if analyzing data with multiple observations per 
id/cluster)}

\item{MCsize}{integer: sample size for simulation to approximate marginal 
hazards ratios}

\item{containmix}{named list of logical scalars with names "count" and "zero"}

\item{bayes}{not used}

\item{x}{keep design matrix? (logical)}

\item{msmcontrol}{named list from \code{\link[qgcomp]{zimsm.fit.control}}}

\item{...}{arguments to zeroinfl (e.g. dist)}
}
\description{
this is an internal function called by 
 \code{\link[qgcomp]{qgcomp.zi.boot}},
 but is documented here for clarity. Generally, users will not need to call
 this function directly.
}
\details{
This function first computes expected outcomes under hypothetical
interventions to simultaneously set all exposures to a specific quantile. These
predictions are based on g-computation, where the exposures are `quantized',
meaning that they take on ordered integer values according to their ranks,
and the integer values are determined by the number of quantile cutpoints used.
The function then takes these expected outcomes and fits an additional model
(a marginal structural model) with the expected outcomes as the outcome and
the intervention value of the exposures (the quantile integer) as the exposure.
Under causal identification assumptions and correct model specification,
the MSM yields a causal exposure-response representing the incremental
change in the expected outcome given a joint intervention on all exposures.
}
\examples{
set.seed(50)
n=100
\donttest{
dat <- data.frame(y=rbinom(n, 1, 0.5)*rpois(n, 1.2), x1=runif(n), x2=runif(n), z=runif(n))
expnms = c("x1", "x2")
q = 4
qdata = quantize(dat, q=q, expnms=expnms)$data
f = y ~ x1 + x2 + z | 1
msmfit <- qgcomp:::zimsm.fit(f, qdata, intvals=(1:q)-1, expnms, main=TRUE,
  degree=1, id=NULL, MCsize=10000, containmix=list(count=TRUE, zero=FALSE),  
  x=FALSE)
msmfit$msmfit
}
}
\seealso{
\code{\link[qgcomp]{qgcomp.cox.boot}}, and \code{\link[qgcomp]{qgcomp.cox.noboot}}
}
\concept{variance mixtures}
