% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base_survival.R
\name{qgcomp.emm.cox.noboot}
\alias{qgcomp.emm.cox.noboot}
\title{EMM for Quantile g-computation with survival outcomes under linearity/additivity}
\usage{
qgcomp.emm.cox.noboot(
  f,
  data,
  expnms = NULL,
  emmvar = NULL,
  q = 4,
  breaks = NULL,
  id = NULL,
  weights,
  cluster = NULL,
  alpha = 0.05,
  errcheck = TRUE,
  ...
)
}
\arguments{
\item{f}{R style survival formula, which includes \code{\link[survival]{Surv}}
in the outcome definition. E.g. \code{Surv(time,event) ~ exposure}. Offset
terms can be included via \code{Surv(time,event) ~ exposure + offset(z)}}

\item{data}{data frame}

\item{expnms}{character vector of exposures of interest}

\item{emmvar}{(character) name of effect measure modifier in dataset (if categorical, must be coded as a factor variable)}

\item{q}{NULL or number of quantiles used to create quantile indicator variables
representing the exposure variables. If NULL, then gcomp proceeds with un-transformed
version of exposures in the input datasets (useful if data are already transformed,
or for performing standard g-computation)}

\item{breaks}{(optional) NULL, or a list of (equal length) numeric vectors that
characterize the minimum value of each category for which to
break up the variables named in expnms. This is an alternative to using 'q'
to define cutpoints.}

\item{id}{(optional) NULL, or variable name indexing individual units of
observation (only needed if analyzing data with multiple observations per
id/cluster)}

\item{weights}{"case weights" - passed to the "weight" argument of
\code{\link[survival]{coxph}}}

\item{cluster}{not yet implemented}

\item{alpha}{alpha level for confidence limit calculation}

\item{errcheck}{(logical, default=TRUE) include some basic error checking. Slightly
faster if set to false (but be sure you understand risks)}

\item{...}{arguments to glm (e.g. family)}
}
\value{
a qgcompfit object, which contains information about the effect
measure of interest (psi) and associated variance (var.psi), as well
as information on the model fit (fit) and information on the
weights/standardized coefficients in the positive (pos.weights) and
negative (neg.weights) directions.
}
\description{
This function performs quantile g-computation in a survival
setting, , allowing
effect measure modification by a binary, categorical or continuous covariate. This allows
testing of statistical interaction as well as estimation of stratum specific effects.
}
\examples{
set.seed(5)
N=200
dat <- data.frame(time=(tmg <- pmin(.1,rweibull(N, 10, 0.1))),
                d=1.0*(tmg<0.1), x1=runif(N), x2=runif(N), z=runif(N))
expnms=paste0("x", 1:2)
f = survival::Surv(time, d)~x1 + x2+z
(fit1 <- survival::coxph(f, data = dat))
(obj <- qgcomp.emm.cox.noboot(f, expnms = expnms, emmvar="z", data = dat))

#categorical emm
dat <- data.frame(time=(tmg <- pmin(.1,rweibull(N, 10, 0.1))),
                d=1.0*(tmg<0.1), x1=runif(N), x2=runif(N),
                z=sample(0:2, N, replace=TRUE))
 dat$z = as.factor(dat$z)
expnms=paste0("x", 1:2)
f = survival::Surv(time, d)~x1 + x2+z
(obj2 <- qgcomp.emm.cox.noboot(f, expnms = expnms, emmvar="z", data = dat))

}
\seealso{
\code{\link[qgcomp]{qgcomp.cox.noboot}}
}
\concept{variance mixtures}
