% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgis-function.R
\name{qgis_run_algorithm_p}
\alias{qgis_run_algorithm_p}
\title{Run an algorithm using 'qgis_process': pipe-friendly wrapper}
\usage{
qgis_run_algorithm_p(
  .data,
  algorithm,
  ...,
  .select = "OUTPUT",
  .clean = TRUE,
  .quiet = TRUE
)
}
\arguments{
\item{.data}{Passed to the first input of \code{algorithm}.
If \code{.data} is a \code{qgis_result} (the result of a previous processing
step), \code{.data[[.select]]} is passed instead.}

\item{algorithm}{A qualified algorithm name
(e.g., \code{"native:buffer"}).}

\item{...}{Other algorithm arguments.
These values are evaluated once and immediately, so you shouldn't
call \code{\link[=qgis_tmp_file]{qgis_tmp_file()}} here.}

\item{.select}{String.
The name of the element to select from \code{.data} if the latter is a
\code{qgis_result}.
Defaults to \code{"OUTPUT"}.}

\item{.clean}{Logical.
Should an incoming \code{qgis_result} be cleaned (using \code{\link[=qgis_clean_result]{qgis_clean_result()}})
after processing?}

\item{.quiet}{Use \code{FALSE} to get extra output from 'qgis_process'.
This can be useful in debugging.}
}
\value{
A \code{qgis_result} object.
}
\description{
\code{\link[=qgis_run_algorithm_p]{qgis_run_algorithm_p()}} wraps \code{\link[=qgis_run_algorithm]{qgis_run_algorithm()}}, passing
its first argument to the first argument of the QGIS \code{algorithm}.
This makes it more convenient in a pipeline (hence '_p' in the name).
}
\details{
Uses \code{\link[=qgis_function]{qgis_function()}} under the hood.
}
\examples{
\dontshow{if (has_qgis()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
system.file(
  "longlake/longlake_depth.gpkg",
  package = "qgisprocess"
) |>
  qgis_run_algorithm_p(
    "native:buffer",
    DISTANCE = 10
  )
\dontshow{\}) # examplesIf}
}
\seealso{
Other functions to run one geoprocessing algorithm: 
\code{\link{qgis_run_algorithm}()}
}
\concept{functions to run one geoprocessing algorithm}
