% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simQLData.R
\name{simQLdata}
\alias{simQLdata}
\title{Simulate the statistical model}
\usage{
simQLdata(sim, ..., nsim, X = NULL, mode = c("list", "matrix", "mean"),
  cl = NULL, iseed = NULL, na.rm = getOption("na.rm", TRUE),
  verbose = FALSE)
}
\arguments{
\item{sim}{user supplied simulation function}

\item{...}{arguments passed to `\code{sim}`}

\item{nsim}{number of simulation replications at each parameter}

\item{X}{list or matrix of model parameters}

\item{mode}{type of return value}

\item{cl}{cluster object, \code{NULL} (default), see \code{\link[parallel]{makeCluster}}}

\item{iseed}{integer seed for initializing the cluster workers}

\item{na.rm}{whether to remove `\code{NA}` values from simulation results}

\item{verbose}{if \code{TRUE}, then print intermediate output}
}
\value{
List of (aggregated) simulation results of class \code{simQL} and the following attributes:    
	\item{X}{ matrix of sample points equal to `\code{X}`, if supplied, or
				 the result of \code{\link{multiDimLHS}}}
 \item{nsim}{ number of simulation runs at each parameter} 
 \item{iseed}{ an integer seed value to initialize cluster workers}
 \item{error}{ only in case of errors detected in simulation function}
}
\description{
The function runs simulations of the user-defined statistical model
 either for a single parameter or a list of parameters.
}
\details{
Basically, the given simulation function `\code{sim}` is called for each parameter value
 `\code{nsim}` times and the results are returned depending on the chosen type `\code{mode}`. This is either 
 a list or a matrix as the outcome of function `\code{sim}` or the mean of `\code{nsim}` simulation replications at each parameter.
 
 If `\code{X}` equals \code{NULL} (default), then the design, that is, the matrix of sample points, is first generated
 by function \code{\link{multiDimLHS}} and the result is stored as an attribute named `\code{X}`. In this case, the arguments
 `\code{N}`,`\code{bounds}` and `\code{method}` must be given as named input arguments which are then passed to \code{\link{multiDimLHS}}.
 In case of errors catched, the corresponding simulation runs are omitted from the results if possible.

 We recommend using a cluster object `\code{cl}` depending on the complexity of model simulations. If using a cluster make sure
 to export all functions to the cluster environment beforehand which are required by the user-defined simulation function.
 Also, using the option `\code{qle.cache}` caches results of a function call to be stored in the current working directory.
 The filename is generated by a hash code using the \code{\link[digest]{digest}} package. Setting an integer seed \code{iseed} before
 stores each result in a separate file and makes the data reproducible while loading the data again.
}
\examples{
# generate design points, simulate and return the sample means
sim <- simQLdata(sim=function(x) rlnorm(1,x[1],x[2]),
         nsim=10,N=8, method="maximinLHS",
         lb=c(-1.5,0),ub=c(2,1), mode="mean") 
  
}
\author{
M. Baaske
}
