% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciqte.R
\name{ci.qte}
\alias{ci.qte}
\title{ci.qte}
\usage{
ci.qte(formla, xformla = NULL, x = NULL, data, w = NULL,
  probs = seq(0.05, 0.95, 0.05), se = TRUE, iters = 100,
  alp = 0.05, method = "logit", retEachIter = FALSE,
  printIter = FALSE, pl = FALSE, cores = 2)
}
\arguments{
\item{formla}{The formula y ~ d where y is the outcome and d is the
treatment indicator (d should be binary), d should be equal to one
in all time periods for individuals that are eventually treated}

\item{xformla}{A optional one sided formula for additional covariates that
will be adjusted for.  E.g ~ age + education.  Additional covariates can
also be passed by name using the x paramater.}

\item{x}{Vector of covariates.  Default is no covariates}

\item{data}{A data.frame containing all the variables used}

\item{w}{an additional vector of sampling weights}

\item{probs}{A vector of values between 0 and 1 to compute the QTET at}

\item{se}{Boolean whether or not to compute standard errors}

\item{iters}{The number of iterations to compute bootstrap standard errors.
This is only used if se=TRUE}

\item{alp}{The significance level used for constructing bootstrap
confidence intervals}

\item{method}{Method to compute propensity score.  Default is logit; other
option is probit.}

\item{retEachIter}{Boolean whether or not to return list of results
from each iteration of the bootstrap procedure (default is FALSE).
This is potentially useful for debugging but can cause errors due
to running out of memory.}

\item{printIter}{For debugging only; should leave at default FALSE unless
you want to see a lot of output}

\item{pl}{boolean for whether or not to compute bootstrap error in parallel.
Note that computing standard errors in parallel is a new feature and may
not work at all on Windows.}

\item{cores}{the number of cores to use if bootstrap standard errors are
computed in parallel}
}
\value{
QTE object
}
\description{
The \code{ci.qtet} method implements estimates the Quantile
Treatment Effect (QTE) under a Conditional Independence
Assumption (sometimes this is called Selection on Observables) developed
in Firpo (2007).  This method using propensity score re-weighting
and minimizes a check function to compute the QTET.  Standard errors
(if requested) are computed using the bootstrap.
}
\examples{
## Load the data
data(lalonde)

##Estimate the QTET of participating in the job training program;
##This is the no covariate case.  Note: Because individuals that participate
## in the job training program are likely to be much different than
## individuals that do not (e.g. less experience and less education), this
## method is likely to perform poorly at estimating the true QTET
q1 <- ci.qte(re78 ~ treat, x=NULL, data=lalonde.psid, se=FALSE,
 probs=seq(0.05,0.95,0.05))
summary(q1)

##This estimation controls for all the available background characteristics.
q2 <- ci.qte(re78 ~ treat,
 xformla=~age + I(age^2) + education + black + hispanic + married + nodegree,
 data=lalonde.psid, se=FALSE, probs=seq(0.05, 0.95, 0.05))
summary(q2)

}
\references{
Firpo, Sergio.   ``Efficient Semiparametric Estimation of Quantile Treatment
 Effects.'' Econometrica 75.1, pp. 259-276, 2015.
}
