% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/null_model.R, R/null_model2.R
\name{null_model}
\alias{null_model}
\alias{print.qtlpoly.null}
\title{Null model}
\usage{
null_model(
  data,
  offset.data = NULL,
  pheno.col = NULL,
  n.clusters = NULL,
  plot = NULL,
  verbose = TRUE
)

\method{print}{qtlpoly.null}(x, pheno.col = NULL, ...)

\method{print}{qtlpoly.null}(x, pheno.col = NULL, ...)
}
\arguments{
\item{data}{an object of class \code{qtlpoly.data}.}

\item{offset.data}{a data frame with the same dimensions of \code{data$pheno} containing offset variables; if \code{NULL} (default), no offset variables are considered.}

\item{pheno.col}{a numeric vector with the phenotype columns to be analyzed; if \code{NULL}, all phenotypes from \code{'data'} will be included.}

\item{n.clusters}{number of parallel processes to spawn.}

\item{plot}{a suffix for the file's name containing simple plots of every QTL search round, e.g. "null" (default); if \code{NULL}, no file is produced.}

\item{verbose}{if \code{TRUE} (default), current progress is shown; if \code{FALSE}, no output is produced.}

\item{x}{an object of class \code{qtlpoly.null} to be printed.}

\item{...}{currently ignored}
}
\value{
An object of class \code{qtlpoly.null} which contains a list of \code{results} for each trait with the following components:

    \item{pheno.col}{a phenotype column number.}
    \item{stat}{a vector containing values from score statistics.}
    \item{pval}{a vector containing \emph{p}-values from score statistics.}
    \item{qtls}{a data frame with information from the mapped QTL (\code{NULL} at this point).}
}
\description{
Creates a null model (with no QTL) for each trait.
}
\examples{
  \donttest{
  # Estimate conditional probabilities using mappoly package
  library(mappoly)
  library(qtlpoly)
  genoprob4x = lapply(maps4x[c(5)], calc_genoprob)
  data = read_data(ploidy = 4, geno.prob = genoprob4x, pheno = pheno4x, step = 1)

  # Build null models
  null.mod = null_model(data = data, pheno.col = 1, n.clusters = 1)
  }

}
\references{
Pereira GS, Gemenet DC, Mollinari M, Olukolu BA, Wood JC, Mosquera V, Gruneberg WJ, Khan A, Buell CR, Yencho GC, Zeng ZB (2020) Multiple QTL mapping in autopolyploids: a random-effect model approach with application in a hexaploid sweetpotato full-sib population, \emph{Genetics} 215 (3): 579-595. \doi{10.1534/genetics.120.303080}.
    
    Qu L, Guennel T, Marshall SL (2013) Linear score tests for variance components in linear mixed models and applications to genetic association studies. \emph{Biometrics} 69 (4): 883–92.
}
\seealso{
\code{\link[qtlpoly]{read_data}}
}
\author{
Guilherme da Silva Pereira, \email{gdasilv@ncsu.edu}
}
