% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{write_quadtree_ptr}
\alias{write_quadtree_ptr}
\alias{write_quadtree_ptr,character,Quadtree-method}
\title{Read/write a \code{Quadtree}}
\usage{
\S4method{write_quadtree_ptr}{character,Quadtree}(x, y)
}
\arguments{
\item{x}{character; the filepath to read from or write to}

\item{y}{a \code{\link{Quadtree}}}
}
\value{
no return value
}
\description{
This is for debugging only, and users should never need to use
  this function - use \code{\link{write_quadtree}()} instead.
  \code{\link{write_quadtree}()} serializes the \code{CppQuadtree} object
  (note that the underlying C++ object is actually called
  \code{QuadtreeWrapper}, but it is exposed to R as \code{CppQuadtree}) stored
  in the \code{ptr} slot of \code{\link{Quadtree}}. 
  
  This function, however, serializes only the \code{Quadtree} object contained by the
  \code{QuadtreeWrapper}.
}
\examples{
library(quadtree)
data(habitat)

qt <- quadtree(habitat, .1)

path <- tempfile(fileext = "qtree")
write_quadtree_ptr(path, qt)
}
