% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distMyJackknife.R
\name{jackknifeMatrix}
\alias{jackknifeMatrix}
\title{Compute correlation matrix with jack}
\usage{
jackknifeMatrix(dataX, distmethod, ...)
}
\arguments{
\item{dataX}{data.frame with transition intensities per peptide}

\item{distmethod}{dist or correlation method working with matrix i.e. cor}

\item{...}{further parameters to method}
}
\value{
summarizes results producced with my_jackknife
}
\description{
Compute correlation matrix with jack
}
\examples{
dataX <- matrix(rnorm(20), ncol=4) 
rownames(dataX)<- paste("R",1:nrow(dataX),sep="")
colnames(dataX)<- paste("C",1:ncol(dataX),sep="")
tmp <- my_jackknife(dataX, cor, use="pairwise.complete.obs", method="pearson")

jackknifeMatrix(dataX, cor)
jackknifeMatrix(dataX, cor, method="spearman")
}
