% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textplot_keyness.R
\name{textplot_keyness}
\alias{textplot_keyness}
\title{Plot word keyness}
\usage{
textplot_keyness(
  x,
  show_reference = TRUE,
  show_legend = TRUE,
  n = 20L,
  min_count = 2L,
  margin = 0.05,
  color = c("darkblue", "gray"),
  labelcolor = "gray30",
  labelsize = 4,
  font = NULL
)
}
\arguments{
\item{x}{a return object from \code{\link[quanteda.textstats:textstat_keyness]{quanteda.textstats::textstat_keyness()}}}

\item{show_reference}{logical; if \code{TRUE}, show key reference features in
addition to key target features}

\item{show_legend}{logical; if \code{TRUE}, show legend}

\item{n}{integer; number of features to plot}

\item{min_count}{numeric; minimum total count of feature across the target
and reference categories, for a feature to be included in the plot}

\item{margin}{numeric; size of margin where feature labels are shown}

\item{color}{character or integer; colours of bars for target and reference
documents. \code{color} must have two elements when \code{show_reference = TRUE}.
See \link[ggplot2:aes_colour_fill_alpha]{ggplot2::color}.}

\item{labelcolor}{character; color of feature labels.}

\item{labelsize}{numeric; size of feature labels and bars.  See
\link[ggplot2:aes_linetype_size_shape]{ggplot2::size}.}

\item{font}{character; font-family of texts. Use default font if \code{NULL}.}
}
\value{
a \pkg{ggplot2} object
}
\description{
Plot the results of a "keyword" of features comparing their differential
associations with a target and a reference group, after calculating keyness
using \code{\link[quanteda.textstats:textstat_keyness]{quanteda.textstats::textstat_keyness()}}.
}
\examples{
\dontrun{
library("quanteda")
# compare Trump speeches to other Presidents by chi^2
dfmat1 <- data_corpus_inaugural \%>\%
     corpus_subset(Year > 1980) \%>\%
     tokens(remove_punct = TRUE) \%>\%
     tokens_remove(stopwords("en")) \%>\%
     dfm()
dfmat1 <- dfm_group(dfmat1, groups = dfmat1$President)
tstat1 <- quanteda.textstats::textstat_keyness(dfmat1, target = "Trump")
textplot_keyness(tstat1, margin = 0.2, n = 10)
tstat1 <- quanteda.textstats::textstat_keyness(dfmat1, target = "Trump")
textplot_keyness(tstat1, margin = 0.2, n = 10)

# compare contemporary Democrats v. Republicans
corp <- data_corpus_inaugural \%>\%
    corpus_subset(Year > 1960)
corp$party <- ifelse(docvars(corp, "President") \%in\% c("Nixon", "Reagan", "Bush", "Trump"),
                     "Republican", "Democrat")
dfmat2 <- corp \%>\%
    tokens(remove_punct = TRUE) \%>\%
    tokens_remove(stopwords("en")) \%>\%
    dfm()
tstat2 <- quanteda.textstats::textstat_keyness(dfm_group(dfmat2, groups = dfmat2$party),
                                               target = "Democrat", measure = "lr")
textplot_keyness(tstat2, color = c("blue", "red"), n = 10)
}
}
\seealso{
\code{\link[quanteda.textstats:textstat_keyness]{quanteda.textstats::textstat_keyness()}}
}
\author{
Haiyan Wang and Kohei Watanabe
}
\keyword{textplot}
