% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corpus_reshape.R
\name{corpus_reshape}
\alias{corpus_reshape}
\title{recast the document units of a corpus}
\usage{
corpus_reshape(x, to = c("sentences", "paragraphs", "documents"), ...)
}
\arguments{
\item{x}{corpus whose document units will be reshaped}

\item{to}{new document units in which the corpus will be recast}

\item{...}{not used}
}
\value{
A corpus object with the documents defined as the new units,
  including document-level meta-data identifying the original documents.
}
\description{
For a corpus, reshape (or recast) the documents to a different level of aggregation.  
Units of aggregation can be defined as documents, paragraphs, or sentences.
Because the corpus object records its current "units" status, it is possible
to move from recast units back to original units, for example from documents,
to sentences, and then back to documents (possibly after modifying the sentences).
}
\examples{
# simple example
mycorpus <- corpus(c(textone = "This is a sentence.  Another sentence.  Yet another.", 
                     textwo = "Premiere phrase.  Deuxieme phrase."), 
                   docvars = data.frame(country=c("UK", "USA"), year=c(1990, 2000)),
                   metacorpus = list(notes = "Example showing how corpus_reshape() works."))
summary(mycorpus)
summary(corpus_reshape(mycorpus, to = "sentences"), showmeta=TRUE)

# example with inaugural corpus speeches
(mycorpus2 <- corpus_subset(data_corpus_inaugural, Year>2004))
paragCorpus <- corpus_reshape(mycorpus2, to="paragraphs")
paragCorpus
summary(paragCorpus, 100, showmeta=TRUE)
## Note that Bush 2005 is recorded as a single paragraph because that text used a single
## \\n to mark the end of a paragraph.
}
\keyword{corpus}
