% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{convert-wrappers}
\alias{convert-wrappers}
\alias{as.wfm}
\alias{as.wfm.dfm}
\alias{as.DocumentTermMatrix}
\alias{as.DocumentTermMatrix.dfm}
\alias{dfm2austin}
\alias{dfm2tm}
\alias{dfm2lda}
\alias{dtm2lda}
\alias{dfm2dtm}
\alias{dfm2stm}
\title{Convenience wrappers for dfm convert}
\usage{
as.wfm(x)

\method{as.wfm}{dfm}(x)

as.DocumentTermMatrix(x)

\method{as.DocumentTermMatrix}{dfm}(x)

dfm2austin(x)

dfm2tm(x, weighting = tm::weightTf)

dfm2lda(x, omit_empty = TRUE)

dtm2lda(x, omit_empty = TRUE)

dfm2dtm(x, omit_empty = TRUE)

dfm2stm(x, docvars = NULL, omit_empty = TRUE)
}
\arguments{
\item{x}{the dfm to be converted}

\item{weighting}{a \pkg{tm} weight, see \code{\link[tm]{weightTf}}}

\item{omit_empty}{logical; if \code{TRUE}, omit empty documents and features
from the converted dfm. This is required for some formats (such as STM)
that do not accept empty documents.  Only used when \code{to = "lda"} or
\code{to = "topicmodels"}.  For \code{to = "stm"} format, `omit_empty`` is
always \code{TRUE}.}

\item{docvars}{optional data.frame of document variables used as the
\code{meta} information in conversion to the \pkg{stm} package format.
This aids in selecting the document variables only corresponding to the
documents with non-zero counts.  Only affects the "stm" format.}

\item{...}{additional arguments used only by \code{as.DocumentTermMatrix}}
}
\value{
A converted object determined by the value of \code{to} (see above). 
  See conversion target package documentation for more detailed descriptions 
  of the return formats.
}
\description{
To make the usage as consistent as possible with other packages, quanteda
also provides shortcut wrappers to \code{\link{convert}}, designed to be
similar in syntax to analogous commands in the packages to whose format they
are converting.
}
\details{
\code{as.wfm} converts a quanteda \link{dfm} into the
\code{wfm} format used by the \code{austin} package.

\code{as.DocumentTermMatrix} will convert a quanteda \link{dfm} into
  the \pkg{tm} package's \link[tm]{DocumentTermMatrix} format. Note: The
  \pkg{tm} package version of \code{as.TermDocumentMatrix} allows a
  \code{weighting} argument, which supplies a weighting function for 
  \link[tm]{TermDocumentMatrix}.  Here the default is for term frequency
  weighting. If you want a different weighting, apply the weights after
  converting using one of the \pkg{tm} functions. For other available
  weighting functions from the \pkg{tm} package, see 
  \code{\link[tm]{TermDocumentMatrix}}.

\code{dfm2lda} provides converts a \link{dfm} into the list representation
of terms in documents used by the \pkg{lda} package (a list with components 
"documents" and "vocab" as needed by 
  \code{\link[lda]{lda.collapsed.gibbs.sampler}}).

\code{dfm2ldaformat} provides converts a \link{dfm} into the list
representation of terms in documents used by the \pkg{lda} package (a list
with components "documents" and "vocab" as needed by
\code{\link[lda]{lda.collapsed.gibbs.sampler}}).
}
\note{
Additional coercion methods to base R objects are also available: 
  \describe{ \item{\code{\link{as.data.frame}(x)}}{converts a \link{dfm} into
  a \link{data.frame}}
  
  \item{\code{\link{as.matrix}(x)}}{converts a \link{dfm} into a
  \link{matrix}} }
}
\examples{
corp <- corpus_subset(data_corpus_inaugural, Year > 1970)
dfmat <- dfm(corp)

# shortcut conversion to austin package's wfm format
identical(as.wfm(dfmat), convert(dfmat, to = "austin"))

\dontrun{
# shortcut conversion to tm package's DocumentTermMatrix format
identical(as.DocumentTermMatrix(dfmat), convert(dfmat, to = "tm"))
}

\dontrun{
# shortcut conversion to lda package list format
identical(quanteda:::dfm2lda(dfmat), convert(dfmat, to = "lda")) 
}

\dontrun{
# shortcut conversion to lda package list format
identical(dfm2ldaformat(dfmat), convert(dfmat, to = "lda")) 
}
}
\keyword{internal}
