% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errors.R
\name{correl}
\alias{correl}
\alias{correl<-.quantities}
\alias{covar<-.quantities}
\title{Handle Correlations Between \code{quantities} Objects}
\usage{
\method{correl}{quantities}(x, y) <- value

\method{covar}{quantities}(x, y) <- value
}
\arguments{
\item{x}{an object of class \code{quantities}.}

\item{y}{an object of class \code{quantities} of the same length as \code{x}.}

\item{value}{a compatible object of class \code{units} of length 1 or the
same length as \code{x}. For correlations, this means a unitless vector (a
numeric vector is also accepted in this case). For covariances, this means
the same magnitude as \code{x*y}.}
}
\description{
Methods to set or retrieve correlations or covariances between
\code{quantities} objects.
}
\examples{
x <- set_quantities(1:10, m/s, 0.1)
y <- set_quantities(10:1, km/h, 0.2)
correl(x, y) <- 0.1 # accepted
correl(x, y) <- set_units(0.1) # recommended
correl(x, y)
covar(x, y)

}
\seealso{
\code{\link[errors]{correl}}.
}
