% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Class-IntegrQuantileSD.R
\name{IntegrQuantileSD-constructor}
\alias{IntegrQuantileSD-constructor}
\alias{integrQuantileSD}
\title{Create an instance of the \code{\link{IntegrQuantileSD}} class.}
\usage{
integrQuantileSD(object = 2^8, type = c("copula", "Laplace"), ts = rnorm,
  seed.init = 2581, levels.1 = 0.5, levels.2 = levels.1, R = 1,
  quiet = FALSE)
}
\arguments{
\item{object}{the number \code{N} of Fourier frequencies to be used;
alternatively a  \code{\link{QuantileSD}} object can be supplied
(then all the other  parameters will be ignored)}

\item{type}{can be either \code{"Laplace"} or \code{"copula"}; indicates
whether the marginals are to be assumed uniform \eqn{[0,1]}
distributed.}

\item{ts}{a function that has one argument \code{n} and, each time it is
invoked, returns a new time series from the model for which the
integrated quantile spectral density kernel is to be simulated.}

\item{seed.init}{an integer serving as an initial seed for the simulations.}

\item{levels.1}{A vector of length \code{K1} containing the levels \code{x1}
at which the \code{QuantileSD} is to be determined.}

\item{levels.2}{A vector of length \code{K2} containing the levels \code{x2}
at which the \code{QuantileSD} is to be determined.}

\item{R}{an integer that determines the number of independent simulations;
the larger this number the more precise is the result.}

\item{quiet}{Don't report progress to console when computing the \code{R}
              independent quantile periodograms.}
}
\value{
Returns an instance of \code{\link{IntegrQuantileSD}}.
}
\description{
Create an instance of the \code{\link{IntegrQuantileSD}} class.
}
\seealso{
For an example see \code{\link{IntegrQuantileSD}}.
}
\keyword{Constructors}

