% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Class-KernelWeight.R
\docType{methods}
\name{getValues-KernelWeight}
\alias{getValues,KernelWeight-method}
\alias{getValues-KernelWeight}
\title{Get values from a weight object determined by a kernel function \code{W} and
a bandwidth \code{b}.}
\usage{
\S4method{getValues}{KernelWeight}(object, N = length(object@env$values))
}
\arguments{
\item{object}{\code{KernelWeight} of which to get the values}

\item{N}{a \code{numeric} specifying the number of equaly spaced Fourier
frequencies from \eqn{[0,2\pi)}{[0,2pi)} for which the weight will
be computed; by default the number \code{N} specified on construction.}
}
\value{
Returns a vector of size \code{N} as described in the Details section.
}
\description{
For an \code{object} of type \code{KernelWeight} and an optional integer
\code{N} the weights \eqn{W_n}{Wn} are returned as a vector that has
\eqn{W_n(2\pi(k-1)/n)}{Wn(2pi(k-1)/n)} at position \code{k}.
}
\keyword{Access-functions}

